/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.rsf.handlers;

import com.ibm.hwmca.base.custinfo.CustomerInfoData;
import com.ibm.hwmca.base.custinfo.CustomerInfoManager;
import com.ibm.hwmca.base.rsf.handlers.BaseRsfDataTransfer;
import com.ibm.hwmca.base.rsf.handlers.BaseRsfHandlersErrorIds;
import com.ibm.hwmca.base.rsf.requests.BaseRsfRequestImpl;
import com.ibm.hwmca.base.rsf.requests.BaseRsfResultDetails;
import com.ibm.hwmca.base.rsf.sas.CredentialUtils;
import com.ibm.hwmca.base.rsf.sas.LocalCredentialStore;
import com.ibm.hwmca.base.rsf.util.TcpConnection;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkEventText;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.log.MicrocodeLogAttributes;
import com.ibm.hwmca.fw.log.SystemEventLog;
import com.ibm.hwmca.fw.rbf.RbfHandleResponse;
import com.ibm.hwmca.fw.rbf.RbfPrepareResponse;
import com.ibm.hwmca.fw.rbf.RbfRequest;
import com.ibm.hwmca.fw.rbf.RbfRequestHandler;
import com.ibm.hwmca.fw.rbf.RbfRequestType;
import com.ibm.hwmca.fw.rcs.conndata.AccountInfo;
import com.ibm.hwmca.fw.rcs.conndata.AccountingInfo;
import com.ibm.hwmca.fw.rcs.conndata.ConnectionInfoManager;
import com.ibm.hwmca.fw.rcs.path.CallHomePath;
import com.ibm.hwmca.fw.rcs.path.DirectPath;
import com.ibm.hwmca.fw.rcs.path.InvalidStateException;
import com.ibm.hwmca.fw.rcs.path.PathCancelReason;
import com.ibm.hwmca.fw.rcs.path.PathCancelledException;
import com.ibm.hwmca.fw.rcs.path.PathCancelledListener;
import com.ibm.hwmca.fw.rcs.path.PathFailedException;
import com.ibm.hwmca.fw.rcs.path.PathPlatform;
import com.ibm.hwmca.fw.rcs.path.PathPriority;
import com.ibm.hwmca.fw.rcs.path.RcsPath;
import com.ibm.hwmca.fw.rcs.sas.SysInfo;
import com.ibm.hwmca.fw.rcs.sas.SystemAuthentication;
import com.ibm.hwmca.fw.rcs.sas.SystemAuthenticationException;
import com.ibm.hwmca.fw.rcs.sas.SystemIdentifier;
import com.ibm.hwmca.fw.rsf.RsfRequestBody;
import com.ibm.hwmca.fw.util.Trace;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class BaseRsfHandler
extends RbfRequestHandler
implements BaseRsfHandlersErrorIds,
PathCancelledListener {
    private static String TRACE_MASKF = "XRSFHANF";
    private static String TRACE_MASKT = "XRSFHANT";
    private static String TRACE_MASKD = "XRSFHAND";
    private static FrameworkClassLogInfo logInfo = new FrameworkClassLogInfo(-44, "BaseRsfHndlr");
    private static MicrocodeLogAttributes infoLog = MicrocodeLogAttributes.INFO_LOG;
    private static MicrocodeLogAttributes errorLog = MicrocodeLogAttributes.ERROR_LOG;
    private static MicrocodeLogAttributes infoLogDisplayError = new MicrocodeLogAttributes(false, false, true, true, true, true, false, 0);
    private static final int INITIAL = 0;
    private static final int PREPARING = 1;
    private static final int ERROR_PREPARING = 5;
    private static final int DONE_PREPARING = 2;
    private static final int RCS_CANCELED_PREPARING = 6;
    private static final int HANDLING = 3;
    private static final int DONE_HANDLING = 4;
    private boolean terminating = false;
    private int handlerState = 0;
    private static final String RSFSTART = "RSFSTART";
    private static final String RSFERROR = "RSFERROR";
    private static final String RSFGOOD = "RSFGOOD";
    private static final String TRSF_SERVER = "TRSF_SERVER";
    private static boolean localTrace = true;
    public static boolean testPath = false;
    private boolean canceled = false;
    private int errorEventId;
    private boolean verifyError = false;
    private BaseRsfRequestImpl request;
    private RsfRequestBody content;
    private BaseRsfResultDetails responseDetails;
    private RbfHandleResponse response;
    private String requestId;
    private BaseRsfDataTransfer transferAgent;
    private int tcpDestination;
    private RcsPath commPath;
    private TcpConnection connection;
    private SystemIdentifier sysIdentifier;
    private HandlerInfo currentHandler = null;
    private String countryCode;
    private String subdivisionCode;
    private String phoneListType = "phlist";
    private static HandlerInfo[] handlers = new HandlerInfo[]{new HandlerInfo("eserv", 0, "com.ibm.hwmca.base.rsf.handlers.SdrHandler", PathPlatform.ZSERIES, "low", 1), new HandlerInfo("zpap", 0, "com.ibm.hwmca.base.rsf.handlers.ZPapHandler", PathPlatform.ZSERIES, "high", 0), new HandlerInfo("ipap", 0, "com.ibm.hwmca.p.rsf.IPapHandler", PathPlatform.PISERIES, "high", 0), new HandlerInfo("zpi", 0, "com.ibm.hwmca.base.rsf.handlers.ZPapHandler", PathPlatform.PISERIES, "low", 0), new HandlerInfo("spap", 0, "com.ibm.hwmca.p.rsf.EssStorageHandler", PathPlatform.STORAGE, "high", 0), new HandlerInfo("phlist", 0, "com.ibm.hwmca.base.rsf.handlers.ZPapHandler", PathPlatform.GENERIC, "high", 0), new HandlerInfo("sysauth", 0, "com.ibm.hwmca.base.rsf.sas.SystemAuthenticationHandler", PathPlatform.GENERIC, "high", 3), new HandlerInfo("sdr", 0, "com.ibm.hwmca.base.rsf.handlers.SdrHandler", PathPlatform.PISERIES, "low", 1), new HandlerInfo("szpap", 0, "com.ibm.hwmca.base.rsf.handlers.ZPapHandler", PathPlatform.STORAGE, "low", 0), new HandlerInfo("sipap", 0, "com.ibm.hwmca.p.rsf.IPapHandler", PathPlatform.STORAGE, "high", 0), new HandlerInfo("ssdr", 0, "com.ibm.hwmca.base.rsf.handlers.SdrHandler", PathPlatform.STORAGE, "low", 1), new HandlerInfo("zstp", 0, "com.ibm.hwmca.z.rsf.handlers.EtsHandler", PathPlatform.ZSERIES, "low", 0)};
    private static final String etsPathName = "com.ibm.hwmca.z.rcs.path.EtsPath";
    private boolean validHandler = false;
    private boolean specialPath = false;
    private boolean pathOpen = false;
    private static PathPlatform currentPlatform = PathPlatform.GENERIC;
    private static Object platformSynch = new Object();
    private static SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd");
    private static SimpleDateFormat timeFormatter = new SimpleDateFormat("hh:mm:ss a");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseRsfHandler(RbfRequest eRequest) {
        super(eRequest);
        Trace.trace(TRACE_MASKT, "<> BaseRsfHandler::BaseRsfHandler()");
        this.request = (BaseRsfRequestImpl)eRequest;
        this.requestId = this.request.getIdentifier().toString();
        RbfRequestType rbfType = this.request.getType();
        int version = rbfType.getVersion();
        String type = rbfType.getType();
        if (type.equals("zstp")) {
            this.specialPath = true;
        }
        for (int i = 0; i < handlers.length; ++i) {
            if (!BaseRsfHandler.handlers[i].handlerType.equals(type) || BaseRsfHandler.handlers[i].handlerVersion != version) continue;
            this.currentHandler = handlers[i];
        }
        if (this.currentHandler == null) {
            this.logError("<> BaseRsfHandler: no matching handler found", null, (short)28671);
            return;
        }
        Trace.trace(TRACE_MASKF, "BaseRsfHandler: found " + this.currentHandler);
        this.transferAgent = this.currentHandler.getDataTransferClass();
        if (this.transferAgent == null) {
            this.logError("<> BaseRsfHandler: unable to construct data transfer class", null, (short)28671);
            return;
        }
        this.validHandler = true;
        if (testPath) {
            this.commPath = new DirectPath(this.currentHandler.defaultPriority, this.request.getShortDescription());
            this.commPath.setPlatform(this.currentHandler.platform);
        } else if (this.specialPath) {
            try {
                this.commPath = (RcsPath)Class.forName(etsPathName).newInstance();
                this.commPath.setPlatform(this.currentHandler.platform);
                this.commPath.setDescription(this.request.getShortDescription());
                this.commPath.setPriority(this.currentHandler.defaultPriority);
            }
            catch (Exception e) {
                this.logError("<> BaseRsfHandler: unable to construct time source path", null, (short)28671);
                return;
            }
        } else {
            this.commPath = new CallHomePath(this.currentHandler.platform, this.currentHandler.defaultPriority, this.request.getShortDescription());
        }
        this.commPath.setSystem(this.request.getRequestSource());
        this.commPath.setDate(this.request.getInitiationTime());
        Object object = platformSynch;
        synchronized (object) {
            if (this.currentHandler.platform.equals(PathPlatform.GENERIC)) {
                this.commPath.setPlatform(currentPlatform);
            } else {
                currentPlatform = this.currentHandler.platform;
            }
        }
        Trace.trace(TRACE_MASKF, "<- BaseRsfHandler: RcsPath=" + this.commPath + ". Priority=" + this.commPath.getPriority() + ". Platform=" + this.commPath.getPlatform() + ". Description=" + this.commPath.getDescription() + ". System=" + this.commPath.getSystem() + ". Date=" + this.commPath.getDate() + ".");
        this.tcpDestination = this.currentHandler.tcpDestination;
        this.response = new RbfHandleResponse(this.request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RbfPrepareResponse prepareToHandle() {
        AccountingInfo acctingInfo;
        AccountInfo acctInfo;
        this.handlerState = 1;
        Trace.trace(TRACE_MASKT, "-> BaseRsfHandler::prepareToHandle() " + this.requestId);
        if (!this.validHandler) {
            Trace.trace(TRACE_MASKT, "<- BaseRsfHandler::prepareToHandle() " + this.requestId + " returning not capable due to invalid handler");
            this.handlerState = 5;
            this.logInfo("BaseRsfHandler.prepare returning with no valid handler for request " + this.requestId + " and RcsPath=" + this.commPath, null, (short)28432);
            return new RbfPrepareResponse(4);
        }
        if (this.commPath == null) {
            Trace.trace(TRACE_MASKT, "<- BaseRsfHandler::prepareToHandle() " + this.requestId + " returning not capable due to null communication path");
            this.handlerState = 5;
            this.logInfo("BaseRsfHandler.prepare returning with null path for request " + this.requestId, null, (short)28432);
            return new RbfPrepareResponse(4);
        }
        if (this.isCanceled()) {
            this.handlerState = 2;
            this.logInfo("BaseRsfHandler.prepare returning canceled request " + this.requestId + " and RcsPath=" + this.commPath, null, (short)28432);
            return new RbfPrepareResponse(4);
        }
        CustomerInfoData data = CustomerInfoManager.getCustomerInfoManager().getCustomerInfo();
        this.countryCode = data.getSystemCountryCode();
        this.subdivisionCode = data.getSystemSubdivisionCode();
        Trace.trace(TRACE_MASKF, "BaseRsfHandler.prepare: country code=" + this.countryCode + " subdivision code=" + this.subdivisionCode + ".");
        if (this.countryCode == null || this.countryCode.trim().length() == 0) {
            if (currentPlatform.equals(PathPlatform.ZSERIES) || CredentialUtils.credentialDataTest) {
                this.countryCode = "US";
                this.subdivisionCode = "NY";
                data.setSystemCountryCode(this.countryCode);
                data.setSystemSubdivisionCode(this.subdivisionCode);
                CustomerInfoManager.getCustomerInfoManager().setCustomerInfo(data);
            } else {
                this.logError("BaseRsfHandler.prepareToHandle: no system country code available on system", null, (short)28417);
                this.handlerState = 5;
                return new RbfPrepareResponse(4);
            }
        }
        if ((acctInfo = (acctingInfo = ConnectionInfoManager.getConnectionInfoManager().getAccountingInfo(currentPlatform, this.countryCode, this.subdivisionCode)).getAccountInfo("Account_URSF")) == null) {
            this.logError("BaseRsfHandler:prepareToHandle unable to obtain account information", null, (short)28417);
            this.handlerState = 5;
            return new RbfPrepareResponse(4);
        }
        this.request.setAccountInfo(acctInfo);
        try {
            Trace.trace(TRACE_MASKF, "BaseRsfHandler:prepare to handler about to issue waitForAvailiability for commPath=" + this.commPath);
            this.commPath.waitForAvailability();
        }
        catch (InvalidStateException e) {
            if (!this.isCanceled()) {
                HException h = new HException(e);
                this.logError("BaseRsfHandler::prepareToHandle(): Illegal State '" + this.commPath.getState() + "' for RcsPath=" + this.commPath, h, (short)28671);
                this.handlerState = 5;
            } else {
                Trace.trace(TRACE_MASKF, "<- BaseRsfHandler::prepareToHandle: canceled path before available");
                this.logInfo("BaseRsfHandler.prepare returning canceled request " + this.requestId + " and RcsPath=" + this.commPath, null, (short)28432);
                this.handlerState = 2;
            }
            return new RbfPrepareResponse(4);
        }
        catch (PathCancelledException e) {
            boolean terminated;
            boolean userCanceled = false;
            BaseRsfHandler baseRsfHandler = this;
            synchronized (baseRsfHandler) {
                terminated = this.terminating;
            }
            this.setCanceled(true);
            if (this.commPath.getCancelReason().equals(PathCancelReason.USER)) {
                Trace.trace(TRACE_MASKF, "BaseRsfHandler::prepareToHandle() path canceled by user - calling cancel");
                this.request.cancel();
                this.handlerState = 6;
                this.logInfo("BaseRsfHandler.prepare returning canceled request " + this.requestId + " and RcsPath=" + this.commPath, null, (short)28432);
                return new RbfPrepareResponse(4);
            }
            Trace.trace(TRACE_MASKF, "BaseRsfHandler:: prepareToHandle - path canceled");
            Trace.trace(TRACE_MASKF, e);
            Trace.trace(TRACE_MASKT, "<- BaseRsfHandler::prepareToHandle() " + this.requestId + " request path canceled");
            this.handlerState = terminated ? 2 : 5;
            this.logInfo("BaseRsfHandler.prepare returning canceled request " + this.requestId + " and RcsPath=" + this.commPath, null, (short)28432);
            return new RbfPrepareResponse(4);
        }
        if (!this.checkLocalCredentials()) {
            this.handlerState = 5;
            this.logInfo("BaseRsfHandler.prepare returning because unable to get local credentials for request " + this.requestId + " and RcsPath=" + this.commPath, null, (short)28432);
            return new RbfPrepareResponse(4);
        }
        Trace.trace(TRACE_MASKT, "<- BaseRsfHandler::prepareToHandle() " + this.requestId + " ready to handler request");
        this.handlerState = 2;
        this.logInfo("BaseRsfHandler.prepare returning with ready to handle for request " + this.requestId + " and RcsPath=" + this.commPath, null, (short)28432);
        return new RbfPrepareResponse(0);
    }

    public void pathCancelled(PathCancelReason reason) {
        Trace.trace(TRACE_MASKT, "-> BaseRsfHandler::pathCancelled() " + this.requestId + " for reason:" + reason);
        this.setCanceled(true);
        if (reason.equals(PathCancelReason.USER)) {
            this.request.cancel();
        }
        Trace.trace(TRACE_MASKT, "<-BaseRsfHandler::pathCancelled() " + this.requestId);
    }

    private boolean checkLocalCredentials() {
        Trace.trace(TRACE_MASKT, "-> BaseRsfHandler::checkLocalCredentials()");
        if (this.request.getOwningCredentials() == null) {
            Trace.trace(TRACE_MASKT, "<-BaseRsfHandler::checkLocalCredentials(): already exist");
            return true;
        }
        SysInfo sendingCredentials = null;
        try {
            sendingCredentials = CredentialUtils.getLocalCredentials();
        }
        catch (Exception e) {
            this.logError("BaseRsfHandler: unable to obtain local credentials", e, (short)28671);
            return false;
        }
        if (sendingCredentials == null) {
            sendingCredentials = this.getRemoteCredentials();
            if (sendingCredentials != null) {
                try {
                    LocalCredentialStore.getCredentialStore().storeCredential(null, sendingCredentials);
                }
                catch (Exception e) {
                    this.logError("BaseRsfHandler: unable to store sending credentials in credential store", e, (short)28671);
                    return false;
                }
            } else {
                this.logError("BaseRsfHandler::checkLocalCredentials() getRemote returned null", null, (short)28671);
                return false;
            }
        }
        Trace.trace(TRACE_MASKT, "<-BaseRsfHandler::checkLocalCredentials() new local credentials obtained");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() {
        String msg;
        BaseRsfHandler baseRsfHandler = this;
        synchronized (baseRsfHandler) {
            this.terminating = true;
        }
        int rbfState = this.request.getState();
        int state = this.handlerState;
        boolean canceling = false;
        boolean cancelReason = false;
        if (rbfState == 12) {
            canceling = true;
            msg = "Rsf Request " + this.requestId + ": Handler ended due to cancellation by requesting user ";
        } else {
            msg = rbfState == 6 ? "Rsf Request " + this.requestId + ": Handler ended due to early termination by request broker " : "Rsf Request " + this.requestId + ": Handler ended ";
        }
        Trace.trace(TRACE_MASKT, "-> BaseRsfHandler::terminate() " + this.requestId);
        if (state != 4) {
            this.setCanceled(true);
            if (this.commPath != null) {
                this.commPath.close();
            }
        }
        switch (state) {
            case 0: {
                msg = msg + "before preparing to handle.";
                if (canceling) break;
                msg = msg + "  This indicates another call home server may be handling this request.";
                break;
            }
            case 1: {
                msg = msg + "while preparing to handle.";
                if (canceling) break;
                msg = msg + "\n This indicates another call home server may be handling this request.";
                break;
            }
            case 2: {
                msg = msg + "after returning from prepareToHandle.";
                if (canceling) break;
                msg = msg + "\n This indicates another call home server may be handling this request.";
                break;
            }
            case 6: {
                msg = "Rsf Request " + this.requestId + ": Handler ended due to cancellation while waiting for path availability.";
                break;
            }
            case 5: {
                msg = msg + "after returning from prepareToHandle.\n The handler is unable to handle due to an error.";
                break;
            }
            case 3: {
                msg = msg + "while handling.";
                if (canceling) break;
                msg = msg + "\n  The request was not canceled so this indicates an internal error.";
                break;
            }
            case 4: {
                msg = msg + "after completion of handling.\n  This indicates the handler completed " + "(either successfully or unsuccessfully).";
                break;
            }
            default: {
                msg = msg + "at unknown handler state.\n This indicates an internal error.";
            }
        }
        this.logInfo(msg, null, (short)28432);
        Trace.trace(TRACE_MASKT, "<- BaseRsfHandler::terminate() ");
    }

    private void addDetails() {
        Trace.trace(TRACE_MASKT, "-> BaseRsfHandler::addDetails()");
        this.responseDetails = this.transferAgent.getResult();
        if (this.responseDetails != null) {
            Trace.trace(TRACE_MASKF, "BaseRsfHandler.addDetails null responseDetails received");
            this.response.setDetails(this.responseDetails);
        }
        Trace.trace(TRACE_MASKT, "<- BaseRsfHandler::addDetails()");
    }

    private void setReasonCode(int reasonCode) {
        if (this.responseDetails == null) {
            this.responseDetails = new BaseRsfResultDetails();
            this.response.setDetails(this.responseDetails);
            this.responseDetails.setReasonCode(reasonCode);
        }
    }

    public RbfHandleResponse handle() {
        this.handlerState = 3;
        Trace.trace(TRACE_MASKT, "-> BaseRsfHandler::handle() " + this.requestId + " with path=" + this.commPath);
        String[] substParms = new String[3];
        substParms[2] = this.request.getShortDescription().toString();
        Date startDate = this.request.getInitiationTime();
        substParms[1] = dateFormatter.format(startDate) + " " + timeFormatter.format(startDate);
        substParms[0] = this.request.getRequestSource();
        FrameworkEventText eventText = new FrameworkEventText(673, substParms);
        new SystemEventLog(eventText, TRSF_SERVER).log();
        BaseRsfResultDetails details = new BaseRsfResultDetails();
        details.setReasonCode(7);
        this.response.setDetails(details);
        this.response.setSuccess(true);
        try {
            this.content = (RsfRequestBody)this.request.getBody();
        }
        catch (ClassCastException c) {
            this.logError("BaseRsfHandler.handle: Request is not an instance of RsfRequestBody, but is a" + this.content.getClass(), c, (short)28671);
            this.response.setSuccess(false);
            this.response.setRedrive(false);
            Trace.trace(TRACE_MASKT, "<- BaseRsfHandler::handle() " + this.requestId);
            this.handlerState = 4;
            return this.response;
        }
        if (this.isCanceled()) {
            this.response.setSuccess(false);
            this.response.setRedrive(false);
            Trace.trace(TRACE_MASKT, "<- BaseRsfHandler::handle() " + this.requestId);
            this.handlerState = 4;
            return this.response;
        }
        this.commPath.setCancelListener(this);
        this.request.setPath(this.commPath);
        int rc = 99;
        if (this.specialPath) {
            this.logInfo("BaseRsfHandler.handle about to call transmit with RsfRequestBody data for request " + this.requestId + " and RcsPath=" + this.commPath + ":\n" + this.content, null, (short)28432);
            try {
                rc = this.transferAgent.transmit(null, this.content, this.request);
                this.addDetails();
            }
            catch (IOException e) {
                this.logError("BaseRsfHandler: I/O exception from transmit on ets path", e, (short)28592);
                this.addDetails();
                this.response.setSuccess(false);
                this.response.setRedrive(true);
                this.handlerState = 4;
                return this.response;
            }
            if (rc == 0) {
                this.response.setSuccess(true);
                Trace.trace(TRACE_MASKT, "<- BaseRsfHandler::handle() successful" + this.requestId);
            } else if (rc == 999) {
                this.response.setSuccess(false);
                this.response.setRedrive(false);
                Trace.trace(TRACE_MASKT, "<- BaseRsfHandler::handle() finished with permanent failure " + this.requestId);
            } else if (rc == 90) {
                this.response.setValidRequest(false);
                this.response.setRedrive(false);
                this.response.setSuccess(false);
                Trace.trace(TRACE_MASKT, "<- BaseRsfHandler::handle() finished with invalid request " + this.requestId);
            } else if (rc == 99) {
                this.response.setSuccess(false);
                this.response.setRedrive(true);
                Trace.trace(TRACE_MASKT, "<- BaseRsfHandler::handle() finished with failure " + this.requestId);
            } else {
                this.response.setRedrive(false);
                this.response.setSuccess(false);
                Trace.trace(TRACE_MASKT, "<- BaseRsfHandler::handle() finished with unknown rc " + this.requestId);
            }
            this.handlerState = 4;
            return this.response;
        }
        boolean moreLinks = true;
        while (moreLinks) {
            this.responseDetails = null;
            try {
                if (!this.pathOpen) {
                    this.commPath.open();
                }
            }
            catch (PathFailedException e) {
                this.response.setSuccess(false);
                this.setReasonCode(6);
                this.logError("BaseRsfHandler.handle returning with path failed for " + this.requestId + " and path=" + this.commPath, e, (short)28486);
                this.handlerState = 4;
                return this.response;
            }
            catch (PathCancelledException e) {
                this.response.setSuccess(false);
                boolean userCancel = false;
                PathCancelReason reason = this.commPath.getCancelReason();
                if (reason.equals(PathCancelReason.USER)) {
                    this.request.cancel();
                    userCancel = true;
                } else if (reason.equals(PathCancelReason.APPLICATION)) {
                    userCancel = true;
                }
                if (userCancel) {
                    this.logError("BaseRsfHandler::handle() with canceled path for path=" + this.commPath + " with reason '" + reason + "' for " + this.requestId, e, (short)28486);
                } else {
                    Trace.trace(TRACE_MASKT, "<- BaseRsfHandler::handle() with canceled path for path=" + this.commPath + " with reason '" + reason + "' for " + this.requestId);
                }
                this.handlerState = 4;
                return this.response;
            }
            catch (InvalidStateException e) {
                this.response.setSuccess(false);
                this.setReasonCode(7);
                this.logError("BaseRsfHandler::handle() with invalid path state ' " + this.commPath.getState() + "' for " + this.requestId, e, (short)28671);
                this.handlerState = 4;
                return this.response;
            }
            new SystemEventLog(new FrameworkEventText(150), RSFSTART).log();
            try {
                this.connection = new TcpConnection(this.currentHandler.tcpDestination, this.countryCode, this.subdivisionCode);
                this.connection.setHighPerformance(this.commPath.isHighPerformancePath());
            }
            catch (IllegalArgumentException e) {
                this.logError("BaseRsfHandler.handle: error constructing connection", e, (short)28486);
                this.response.setSuccess(false);
                this.setReasonCode(7);
                Trace.trace(TRACE_MASKT, "<- BaseRsfHandler::handle() " + this.requestId);
                new SystemEventLog(new FrameworkEventText(151), RSFERROR).log();
                this.handlerState = 4;
                return this.response;
            }
            catch (HException e) {
                this.logError("BaseRsfHandler.handle: error constructing connection", e, (short)28671);
                this.response.setSuccess(false);
                this.setReasonCode(7);
                Trace.trace(TRACE_MASKT, "<- BaseRsfHandler::handle() " + this.requestId);
                new SystemEventLog(new FrameworkEventText(151), RSFERROR).log();
                this.handlerState = 4;
                return this.response;
            }
            boolean done = false;
            boolean moreSockets = true;
            while (!done && moreSockets) {
                if (!this.isCanceled()) {
                    this.logInfo("BaseRsfHandler.handle about to call transmit with RsfRequestBody data for request " + this.requestId + " and RcsPath=" + this.commPath + ":\n" + this.content, null, (short)28432);
                    try {
                        rc = this.transferAgent.transmit(this.connection, this.content, this.request);
                        done = true;
                        this.addDetails();
                    }
                    catch (IOException e) {
                        Trace.trace(TRACE_MASKF, "BaseRsfHandler: I/O exception from transmit");
                        rc = 99;
                        this.addDetails();
                        moreSockets = this.connection.failSocket();
                    }
                    continue;
                }
                this.response.setSuccess(false);
                Trace.trace(TRACE_MASKT, "<- BaseRsfHandler::handle() " + this.requestId);
                new SystemEventLog(new FrameworkEventText(151), RSFERROR).log();
                this.handlerState = 4;
                return this.response;
            }
            if (!done) {
                moreLinks = this.commPath.fail();
            }
            if (!done && moreLinks) {
                moreSockets = true;
                try {
                    this.commPath.waitForAvailability();
                    continue;
                }
                catch (InvalidStateException e) {
                    if (!this.isCanceled()) {
                        HException h = new HException(e);
                        this.logError("BaseRsfHandler::handle(): Illegal State '" + this.commPath.getState() + "' for RcsPath in waitForAvailability", h, (short)28671);
                    } else {
                        Trace.trace(TRACE_MASKF, "<- BaseRsfHandler::handle");
                    }
                    new SystemEventLog(new FrameworkEventText(151), RSFERROR).log();
                    this.handlerState = 4;
                    this.response.setSuccess(false);
                    return this.response;
                }
                catch (PathCancelledException e) {
                    this.setCanceled(true);
                    boolean userCancel = false;
                    PathCancelReason reason = this.commPath.getCancelReason();
                    if (reason.equals(PathCancelReason.USER)) {
                        Trace.trace(TRACE_MASKF, "BaseRsfHandler::handle() path canceled by user - calling cancel");
                        userCancel = true;
                        this.request.cancel();
                    } else if (reason.equals(PathCancelReason.APPLICATION)) {
                        userCancel = true;
                    }
                    if (userCancel) {
                        this.logError("BaseRsfHandler: handle - path=" + this.commPath + " canceled in retry waitForAvailability for reason=" + reason + " and request=" + this.requestId, e, (short)28486);
                    } else {
                        Trace.trace(TRACE_MASKF, "BaseRsfHandler:: handle - path canceled in retry waitForAvailability for reason:" + reason);
                        Trace.trace(TRACE_MASKF, e);
                    }
                    Trace.trace(TRACE_MASKT, "<- BaseRsfHandler::handle() " + this.requestId);
                    this.response.setSuccess(false);
                    new SystemEventLog(new FrameworkEventText(151), RSFERROR).log();
                    this.handlerState = 4;
                    return this.response;
                }
            }
            this.commPath.close();
            if (rc == 0) {
                this.response.setSuccess(true);
                new SystemEventLog(new FrameworkEventText(152), RSFGOOD).log();
                Trace.trace(TRACE_MASKT, "<- BaseRsfHandler::handle() " + this.requestId);
            } else if (rc == 999) {
                this.response.setSuccess(false);
                this.response.setRedrive(false);
                new SystemEventLog(new FrameworkEventText(151), RSFERROR).log();
                Trace.trace(TRACE_MASKT, "<- BaseRsfHandler::handle() finished with Permanent failure " + this.requestId);
            } else if (rc == 90) {
                this.response.setValidRequest(false);
                this.response.setRedrive(false);
                this.response.setSuccess(false);
                new SystemEventLog(new FrameworkEventText(151), RSFERROR).log();
            } else {
                this.response.setRedrive(true);
                this.response.setSuccess(false);
                new SystemEventLog(new FrameworkEventText(151), RSFERROR).log();
            }
            this.handlerState = 4;
            return this.response;
        }
        this.response.setSuccess(false);
        this.response.setRedrive(true);
        new SystemEventLog(new FrameworkEventText(151), RSFERROR).log();
        this.handlerState = 4;
        return this.response;
    }

    private SysInfo getRemoteCredentials() {
        Trace.trace(TRACE_MASKT, "-> BaseRsfHandler::getRemoteCredentials()");
        SysInfo credentials = null;
        boolean moreLinks = true;
        while (moreLinks) {
            Trace.trace(TRACE_MASKF, "BaseRsfHandler::getRemoteCredentials() about to open path");
            try {
                this.commPath.open();
                this.pathOpen = true;
            }
            catch (PathFailedException e) {
                Trace.trace(TRACE_MASKF, "<-BaseRsfHandler::getRemoteCredentials() with failed path");
                Trace.trace(TRACE_MASKF, e);
                return null;
            }
            catch (PathCancelledException e) {
                PathCancelReason reason = this.commPath.getCancelReason();
                Trace.trace(TRACE_MASKT, "<- BaseRsfHandler::getRemoteCredentials() with canceled path with reason '" + reason + "'.");
                return null;
            }
            catch (InvalidStateException e) {
                Trace.trace(TRACE_MASKT, "<- BaseRsfHandler::getRemoteCredentials() with invalid path state ' " + this.commPath.getState() + "'.");
                Trace.trace(TRACE_MASKF, e);
                return null;
            }
            try {
                this.connection = new TcpConnection(3, this.countryCode, this.subdivisionCode);
            }
            catch (Exception e) {
                Trace.trace(TRACE_MASKF, "BaseRsfHandler.getRemoteCredentials: error constructing connection");
                Trace.trace(TRACE_MASKF, e);
                return null;
            }
            boolean done = false;
            boolean moreSockets = true;
            while (!done && moreSockets) {
                try {
                    SystemIdentifier sysIdentifier = LocalCredentialStore.getLocalSystemIdentifier();
                    credentials = SystemAuthentication.enrollSystem(this.connection, sysIdentifier, CredentialUtils.getLocalClientLocation(), CredentialUtils.getLocalCompanyIdentifier(), null, null, null, null, null);
                    LocalCredentialStore.getCredentialStore().storeLocalCredential(credentials, sysIdentifier);
                    done = true;
                }
                catch (SystemAuthenticationException e) {
                    Trace.trace(TRACE_MASKT, "<-BaseRsfHandler::getRemoteCredentials() System authentication exception");
                    Trace.trace(TRACE_MASKF, e);
                    return null;
                }
                catch (IOException e) {
                    Trace.trace(TRACE_MASKF, "BaseRsfHandler::getRemoteCredentials I/O exception");
                    Trace.trace(TRACE_MASKF, e);
                    moreSockets = this.connection.failSocket();
                }
            }
            if (done || !(moreLinks = this.commPath.fail())) break;
            moreSockets = true;
            try {
                this.commPath.waitForAvailability();
            }
            catch (InvalidStateException e) {
                Trace.trace(TRACE_MASKF, "<-BaseRsfHandler::getRemoteCredentials() - invalid path state on path retry");
                Trace.trace(TRACE_MASKF, e);
                return null;
            }
            catch (PathCancelledException e) {
                Trace.trace(TRACE_MASKT, "<- BaseRsfHandler::getRemoteCredentials() -path canceled");
                Trace.trace(TRACE_MASKF, e);
                return null;
            }
        }
        return credentials;
    }

    private synchronized void setCanceled(boolean cancel) {
        if (this.validHandler && this.transferAgent != null) {
            this.transferAgent.requestCancelling();
        }
        this.canceled = cancel;
    }

    private synchronized boolean isCanceled() {
        return this.canceled;
    }

    private void logInfo(String errorMsg, Throwable t, short errorId) {
        FrameworkLog errLog;
        Trace.trace(TRACE_MASKF, errorMsg);
        if (t != null) {
            Trace.trace(TRACE_MASKF, t);
            errLog = new FrameworkLog(logInfo, errorId, t);
        } else {
            errLog = new FrameworkLog(logInfo, errorId);
        }
        errLog.add(errorMsg);
        errLog.log(infoLog);
    }

    private void logError(String errorMsg, Throwable t, short errorId) {
        FrameworkLog errLog;
        Trace.trace(TRACE_MASKF, errorMsg);
        if (t != null) {
            Trace.trace(TRACE_MASKF, t);
            errLog = new FrameworkLog(logInfo, errorId, t);
        } else {
            errLog = new FrameworkLog(logInfo, errorId);
        }
        errLog.add(errorMsg);
        errLog.log(infoLogDisplayError);
    }

    private static class HandlerInfo {
        String dataTransferClassName;
        PathPlatform platform;
        String handlerType;
        int handlerVersion;
        PathPriority defaultPriority;
        BaseRsfDataTransfer dataTransfer;
        int tcpDestination;

        HandlerInfo(String type, int version, String transferClass, PathPlatform platform, String priority, int tcpDestination) {
            this.handlerType = type;
            this.handlerVersion = version;
            this.dataTransferClassName = transferClass;
            this.platform = platform;
            this.defaultPriority = priority.equals("high") ? PathPriority.HIGH : PathPriority.LOW;
            this.tcpDestination = tcpDestination;
        }

        public String toString() {
            return "Handler: " + this.dataTransferClassName + ". Path platform=" + this.platform + ". Priority=" + this.defaultPriority + ".";
        }

        BaseRsfDataTransfer getDataTransferClass() {
            if (this.dataTransferClassName == null) {
                Trace.trace(TRACE_MASKF, "BaseRsfHandler: null data transfer class name.");
                return null;
            }
            try {
                return (BaseRsfDataTransfer)Class.forName(this.dataTransferClassName).newInstance();
            }
            catch (ClassNotFoundException e) {
                Trace.trace(TRACE_MASKF, "BaseRsfHandler: data transfer class not found: " + this.dataTransferClassName);
                return null;
            }
            catch (ClassCastException e) {
                Trace.trace(TRACE_MASKF, "BaseRsfHandler: data transfer class " + this.dataTransferClassName + " does not implement BaseRsfDataTransfer");
                return null;
            }
            catch (Exception e) {
                Trace.trace(TRACE_MASKF, "BaseRsfHandler: Exception trying to construct " + this.dataTransferClassName + " using the null constructor");
                Trace.trace(TRACE_MASKF, e);
                return null;
            }
        }
    }
}

